import ucar.nc2.iosp.grib.*;
import ucar.nc2.iosp.grib.GribServiceProvider.*;

import java.*;
import java.io.*;
import java.util.*;

import ucar.ma2.*;
import ucar.nc2.*;
import ucar.nc2.util.*;
import ucar.nc2.units.DateFormatter;

public class Tester2 {
    private static final String VERSION = "0.01";

  double[] Tvar;
  int n_reads = 0;

    public static void main(String[] args) {
        Tester2 gs = new Tester2(args);
        System.exit(0);
    }

    public Tester2(String[] args) {
      this.n_reads = new Integer(args[0]).intValue();
        String filename = "/w3/rapb/ruc_native_40.nc";

        long start = System.nanoTime();
        int tuv_levels = 0;

        for (int count = 0; count < n_reads; count++) {
            NetcdfFile ncfile = null;
            try {

                ncfile = NetcdfFile.open(filename);
                //System.out.println("ncfile is "+ncfile);
                Array data4D;
                Variable v = null;
                Attribute a = null;

                // get grid parameters for most variables
                Dimension d = ncfile.findDimension("z");
                if (d == null) {
                    System.out.println("Bad dimension for z");
                    System.exit(1);
                }
                tuv_levels = d.getLength();

                // get variables
                int[] origin = new int[]{0, 0, 40, 50};
                int[] tuv_size = new int[]{1, tuv_levels, 1, 1};
                v = ncfile.findVariable("vpt");
                data4D = v.read(origin, tuv_size);
                Tvar = (double[]) data4D.reduce().get1DJavaArray(double.class);
                //System.out.println("successfully read " + filename);

            } catch (Exception e) {
                System.out.println("Exception: " + filename + " " + e);
                e.printStackTrace();
                System.exit(1);

            } finally {
                if (null != ncfile) try {
                    ncfile.close();
                    //System.out.println("closed file");
                } catch (IOException ioe) {
                    System.out.println("trying to close " + filename + " " + ioe);
                }
            }

          /*  for (int i = 0; i < tuv_levels; i++) {
                System.out.println("i: " + i + " t " + Tvar[i]);
            }  */


        }

        long stop = System.nanoTime();
        System.out.printf("java: elapsed time for "+n_reads+" reads is %f seconds %n",
			  (stop - start) / 1000.0 / 1000.0 /1000.);


    }
}


